package com.atr.tedit.utilitybar.state;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
//import android.support.v4.app.Fragment;
import androidx.fragment.app.Fragment;
//import android.support.v4.content.ContextCompat;
import androidx.core.content.ContextCompat;
//import android.support.v4.provider.DocumentFile;
import androidx.documentfile.provider.DocumentFile;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Toast;

import com.atr.tedit.dialog.TDialog;
import com.atr.tedit.file.descriptor.AndFile;
import com.atr.tedit.mainstate.Browser;
import com.atr.tedit.R;
import com.atr.tedit.TEditActivity;
import com.atr.tedit.dialog.HelpDialog;
import com.atr.tedit.settings.Settings;
import com.atr.tedit.settings.dialog.DirectoryPicker;
import com.atr.tedit.utilitybar.UtilityBar;

/**
 * @author Adam T. Ryder
 * <a href="https://www.inventati.org/1337gallery">https://www.inventati.org/1337gallery</a>
 */

public class BrowserState extends UtilityState {
    public BrowserState(UtilityBar bar) {
        super(bar, UtilityBar.STATE_BROWSE);

        boolean twoLayer = (bar.padding_w * 2 + bar.bWidth * 8 + bar.margin * 6) > bar.barWidth;

        Button settings = new Button(BAR.ctx);
        settings.setBackgroundResource(R.drawable.button_settings);
        settings.setId(R.id.seven);
        settings.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!BAR.ctx.getSettingsWindow().canOpen() || ((Browser)BAR.ctx.getFrag()).isAnimating()
                        || ((Browser)BAR.ctx.getFrag()).isLoading())
                    return;

                BAR.ctx.getSettingsWindow().open(true);
            }
        });

        Button dir_parent = new Button(BAR.ctx);
        dir_parent.setBackgroundResource(R.drawable.button_dir_parent);
        dir_parent.setId(R.id.zero);
        dir_parent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ((Browser)BAR.ctx.getFrag()).upDir();
            }
        });
        dir_parent.setEnabled(false);

        Button doc = new Button(BAR.ctx);
        doc.setBackgroundResource(R.drawable.button_doc);
        doc.setId(R.id.one);
        doc.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                BAR.ctx.newDocument(TEditActivity.DEFAULTPATH, "");
            }
        });

        Button pDirs = new Button(BAR.ctx);
        pDirs.setBackgroundResource(R.drawable.button_star);
        pDirs.setId(R.id.two);
        pDirs.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P || Settings.isSaveHistory()) {
                    ((Browser) BAR.ctx.getFrag()).populatePermittedDirectories();
                } else
                    Toast.makeText(BAR.ctx, BAR.ctx.getString(R.string.alert_historyDisabled), Toast.LENGTH_SHORT).show();
            }
        });

        Button newdir = new Button(BAR.ctx);
        newdir.setBackgroundResource(R.drawable.button_dir_new);
        newdir.setId(R.id.three);
        newdir.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!(BAR.ctx.getFrag() instanceof Browser))
                    return;

                Browser browser = (Browser)BAR.ctx.getFrag();
                if (browser.isAnimating() || browser.isLoading())
                    return;

                if (browser.isBrowsingPermittedDirs()) {
                    BAR.ctx.launchDirPermissionIntent();
                    return;
                }
                String bDir = ((Browser)BAR.ctx.getFrag()).getCurrentPath().toJson();
                Browser.NewDirectory newDir = Browser.NewDirectory.newInstance(bDir);
                newDir.show(BAR.ctx.getSupportFragmentManager(), "NewDirectory");
            }
        });

        Button tabs = new Button(BAR.ctx);
        tabs.setBackgroundResource(R.drawable.button_tabs);
        tabs.setId(R.id.four);
        tabs.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                BAR.ctx.tabs();
            }
        });

        Button help = new Button(BAR.ctx);
        help.setBackgroundResource(R.drawable.button_help);
        help.setId(R.id.five);

        Button[] l;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && Build.VERSION.SDK_INT < Build.VERSION_CODES.P) {
            help.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    HelpDialog hd = HelpDialog.newInstance(R.layout.help_browser_prepie, BAR.ctx.getString(R.string.browser));
                    hd.show(BAR.ctx.getSupportFragmentManager(), "HelpDialog");
                }
            });

            Button drives = new Button(BAR.ctx);
            drives.setBackgroundResource(R.drawable.button_drives);
            drives.setId(R.id.six);
            drives.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    Browser browser = (Browser)BAR.ctx.getFrag();
                    if (browser.isAnimating() || browser.isLoading())
                        return;
                    launchVolumePicker();
                }
            });

            if (!twoLayer) {
                LAYERS = new View[1][];
                LAYERS[0] = new Button[]{settings, dir_parent, pDirs, doc, newdir, drives, tabs, help};
            } else {
                Button up = new Button(BAR.ctx);
                up.setBackgroundResource(R.drawable.button_arrow_up);
                up.setId(R.id.seven);
                up.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        BAR.getState().transToLayer(0);
                    }
                });

                Button down = new Button(BAR.ctx);
                down.setBackgroundResource(R.drawable.button_arrow_down);
                down.setId(R.id.eight);
                down.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        BAR.getState().transToLayer(1);
                    }
                });

                Button[] l1 = {settings, dir_parent, pDirs, doc, down, help};
                Button[] l2 = {newdir, drives, tabs, up, help};
                LAYERS = new View[2][];
                LAYERS[0] = l1;
                LAYERS[1] = l2;
            }
            for (int i = 0; i < (twoLayer ? 2 : 1); i++) {
                int count = 0;
                for (View v : LAYERS[i]) {
                    if (count == LAYERS[i].length - 1) {
                        v.setTranslationX(BAR.barWidth - BAR.bWidth - BAR.padding_w);
                        v.setNextFocusRightId(LAYERS[i][0].getId());
                        v.setNextFocusLeftId(LAYERS[i][count - 1].getId());
                    } else {
                        v.setTranslationX(BAR.padding_w + (count * (BAR.margin + bar.bWidth)));
                        v.setNextFocusRightId(LAYERS[i][count + 1].getId());
                        if (count == 0)
                            v.setNextFocusLeftId(LAYERS[i][LAYERS[i].length - 1].getId());
                    }
                    v.setTranslationY(BAR.padding_h);

                    v.setFocusable(true);
                    v.setScaleX(1);
                    v.setScaleY(1);
                    v.setAlpha(1);
                    ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(BAR.bar.getLayoutParams());
                    lp.width = BAR.bWidth;
                    lp.height = BAR.bHeight;
                    v.setLayoutParams(lp);

                    count++;
                }
            }
        } else {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                help.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        HelpDialog hd = HelpDialog.newInstance(R.layout.help_browser, BAR.ctx.getString(R.string.browser));
                        hd.show(BAR.ctx.getSupportFragmentManager(), "HelpDialog");
                    }
                });
            } else {
                help.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        HelpDialog hd = HelpDialog.newInstance(R.layout.help_browser_prelollipop, BAR.ctx.getString(R.string.browser));
                        hd.show(BAR.ctx.getSupportFragmentManager(), "HelpDialog");
                    }
                });
            }

            l = new Button[]{settings, dir_parent, pDirs, doc, newdir, tabs, help};

            int count = 0;
            for (Button v : l) {
                if (count == l.length - 1) {
                    v.setTranslationX(BAR.barWidth - BAR.bWidth - BAR.padding_w);
                    v.setNextFocusRightId(l[0].getId());
                    v.setNextFocusLeftId(l[count - 1].getId());
                } else {
                    v.setTranslationX(BAR.padding_w + (count * (BAR.margin + bar.bWidth)));
                    v.setNextFocusRightId(l[count + 1].getId());
                    if (count == 0)
                        v.setNextFocusLeftId(l[l.length - 1].getId());
                }
                v.setTranslationY(BAR.padding_h);

                v.setFocusable(true);
                v.setWidth(BAR.bWidth);
                v.setHeight(BAR.bHeight);
                v.setScaleX(1);
                v.setScaleY(1);
                v.setAlpha(1);
                ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(BAR.bar.getLayoutParams());
                lp.width = BAR.bWidth;
                lp.height = BAR.bHeight;
                v.setLayoutParams(lp);

                count++;
            }

            LAYERS = new View[1][];
            LAYERS[0] = l;
        }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private void launchVolumePicker() {
        boolean cardPresent = ContextCompat.getExternalFilesDirs(BAR.ctx, "external").length > 1;

        Uri[] volumes = BAR.ctx.getPermittedUris();
        for (int i = 0; i < volumes.length; i++) {
            if (!AndFile.createDescriptor(DocumentFile.fromTreeUri(BAR.ctx, volumes[i]), volumes[i]).exists()) {
                volumes = new Uri[0];
                break;
            }
        }
        if (volumes.length > 0 || !cardPresent) {
            ((Browser)BAR.ctx.getFrag()).launchVolumePicker();
            return;
        }

        LaunchSDCardIntent lsd = new LaunchSDCardIntent();
        lsd.show(BAR.ctx.getSupportFragmentManager(), "SDCardIntentDialog");
    }

    public static class LaunchSDCardIntent extends TDialog {
        private TEditActivity ctx;

        @Override
        public void onAttach(Context context) {
            super.onAttach(context);
            this.ctx = (TEditActivity)context;
        }

        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            setTitle(R.string.launch_sdpicker_title);
            setIcon(R.drawable.tedit_logo_brown);
            setMessage(R.string.launch_sdpicker);
            setNegativeButton(getString(R.string.cancel), new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss();
                    Fragment dp = ctx.getSupportFragmentManager().findFragmentByTag(DirectoryPicker.TAG);
                    if (dp == null) {
                        ((Browser) ctx.getFrag()).launchVolumePicker();
                    } else
                        ((DirectoryPicker)dp).launchVolumePicker(false);
                }
            });
            setPositiveButton(getString(R.string.okay), new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss();
                    ctx.launchSDcardIntent();
                }
            });

            return super.onCreateDialog(savedInstanceState);
        }
    }

}
