package com.atr.tedit.util;

import android.content.Intent;
import android.net.Uri;
//import android.support.v4.provider.DocumentFile;
import androidx.documentfile.provider.DocumentFile;

import com.atr.tedit.R;
import com.atr.tedit.TEditActivity;
import com.atr.tedit.file.descriptor.AndFile;

import java.io.File;

/**
 * @author Adam T. Ryder
 * <a href="https://www.inventati.org/1337gallery">https://www.inventati.org/1337gallery</a>
 */

public class ShareHelper {
    public static String shareFile(AndFile file, String mime, TEditActivity ctx) {
        Intent intent = new Intent(Intent.ACTION_SEND);
        intent.putExtra(Intent.EXTRA_SUBJECT, ctx.getText(R.string.share_fromTEdit));
        intent.putExtra(Intent.EXTRA_TEXT, file.getName());
        intent.setType((mime == null || mime.isEmpty()) ? "text/plain" : mime);

        try {
            Uri uri = (file.getType() == AndFile.TYPE_FILE) ? Uri.fromFile((File)file.getFile()) : ((DocumentFile)file.getFile()).getUri();
            intent.putExtra(Intent.EXTRA_STREAM, uri);
            ctx.startActivity(Intent.createChooser(intent, ctx.getText(R.string.share)));
            return "";
        } catch (Exception e) {
            return e.getMessage();
        }
    }

    public static void shareContent(String content, String mime, TEditActivity ctx) {
        Intent intent = new Intent(Intent.ACTION_SEND);
        intent.putExtra(Intent.EXTRA_TEXT, content);
        intent.putExtra(Intent.EXTRA_SUBJECT, ctx.getText(R.string.share_fromTEdit));
        intent.setType((mime == null || mime.isEmpty()) ? "text/plain" : mime);
        ctx.startActivity(Intent.createChooser(intent, ctx.getText(R.string.share)));
    }
}
