package com.atr.tedit.dialog;

import android.app.Dialog;
import android.os.Bundle;
import android.view.View;

import com.atr.tedit.R;
import com.atr.tedit.TEditActivity;
import com.atr.tedit.file.descriptor.AndFile;
import com.atr.tedit.mainstate.Browser;

import java.io.File;

/**
 * @author Adam T. Ryder
 * <a href="https://www.inventati.org/1337gallery">https://www.inventati.org/1337gallery</a>
 */

public class PossibleBinary extends TDialog {
    String filePath;

    public static PossibleBinary getInstance(String filePath) {
        Bundle bundle = new Bundle();
        bundle.putString("pBinary.filePath", filePath);

        PossibleBinary pBin = new PossibleBinary();
        pBin.setArguments(bundle);

        return pBin;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            filePath = getArguments().getString("pBinary.filePath", "");
        } else {
            filePath = savedInstanceState.getString("pBinary.filePath", "");
        }

        setTitle(R.string.alert);
        setMessage(R.string.alert_binaryfile);
        setNegativeButton(R.string.cancel, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
        setPositiveButton(R.string.confirm, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                AndFile file = AndFile.createDescriptor(filePath, getActivity());
                ((Browser)((TEditActivity)getActivity()).getFrag())
                        .openFile(file, true);
            }
        });

        return super.onCreateDialog(savedInstanceState);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);

        outState.putString("pBinary.filePath", filePath);
    }
}
