package com.atr.tedit.dialog;

import android.app.Dialog;
import android.os.Bundle;
import android.view.View;

import com.atr.tedit.R;

/**
 * @author Adam T. Ryder
 * <a href="https://www.inventati.org/1337gallery">https://www.inventati.org/1337gallery</a>
 */

public class OptionMessage extends TDialog {
    private String title;
    private String message;
    private boolean threeOptions;

    public static OptionMessage getInstance(String title, String message) {
        return getInstance(title, message, false);
    }

    public static OptionMessage getInstance(String title, String message, boolean thirdOption) {
        Bundle bundle = new Bundle();
        bundle.putString("Message.title", title);
        bundle.putString("Message.message", message);
        bundle.putBoolean("Message.thirdOption", thirdOption);

        OptionMessage om = new OptionMessage();
        om.setArguments(bundle);

        return om;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            Bundle bundle = getArguments();
            title = bundle.getString("Message.title", getActivity().getString(R.string.alert));
            message = bundle.getString("Message.message", "");
            threeOptions = bundle.getBoolean("Message.thirdOption", false);
            setTitle(title);
            setMessage(message);
            setPositiveButton(R.string.confirm, null);
            setNegativeButton(R.string.cancel,  new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dismiss();
                }
            });
            if (threeOptions)
                setNeutralButton(R.string.error, null);

        } else {
            title = savedInstanceState.getString("Message.title", getActivity().getString(R.string.alert));
            message = savedInstanceState.getString("Message.message", "");
            threeOptions = savedInstanceState.getBoolean("Message.thirdOption", false);
            setTitle(title);
            setMessage(message);
            setNegativeButton(R.string.cancel, new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dismiss();
                }
            });
            dismiss();
        }

        return super.onCreateDialog(savedInstanceState);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);

        outState.putString("Message.title", title);
        outState.putString("Message.message", message);
        outState.putBoolean("Message.thirdOption", threeOptions);
    }
}
